#ifndef SCANNER_HH
#define SCANNER_HH

// Flex expects the signature of yylex to be defined in the macro YY_DECL, and
// the C++ parser expects it to be declared. We can factor both as follows.

#ifndef YY_DECL

#define	YY_DECL						\
	yy::parser::token_type				\
yy::Scanner::lex(				\
		yy::parser::semantic_type* yylval,		\
		yy::parser::location_type* yylloc		\
		)
#endif

#ifndef __FLEX_LEXER_H
#define yyFlexLexer XigenFlexLexer
#include <FlexLexer.h>
#undef yyFlexLexer
#endif


#include "parser.hh"

namespace yy {

	/** Scanner is a derived class to add some extra function to the scanner
	 * class. Flex itself creates a class named yyFlexLexer, which is renamed using
	 * macros to XigenFlexLexer. However we change the context of the generated
	 * yylex() function to be contained within the Scanner class. This is required
	 * because the yylex() defined in XigenFlexLexer has no parameters. */
	class Scanner : public XigenFlexLexer
	{
		public:
			/** Create a new scanner object. The streams arg_yyin and arg_yyout default
			 * to cin and cout, but that assignment is only made when initializing in
			 * yylex(). */
			Scanner(std::istream* arg_yyin = 0,
					std::ostream* arg_yyout = 0);

			/** Required for virtual functions */
			virtual ~Scanner();

			/** This is the main lexing function. It is generated by flex according to
			 * the macro declaration YY_DECL above. The generated bison parser then
			 * calls this virtual function to fetch new tokens. */
			virtual parser::token_type lex(
					parser::semantic_type* yylval,
					parser::location_type* yylloc
					);

			/** Enable debug output (via arg_yyout) if compiled into the scanner. */
			void set_debug(bool b);
	};

} // namespace xigen

#endif // SCANNER_H

/* vim: set ts=2 sw=2: */
